<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Today's Order</title>
    <style>
        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }
       .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
      }


    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }
        .company-details {
            text-align: right;
            max-width: 65%;
            font-size: 14px;
            line-height: 18px;
        }
        .report-title {
            text-align: center;
            /*text-decoration: underline;*/
            font-size: 20px;
            margin: 10px 0;
        }
        .report-date {
            /*text-align: right;*/
            font-size: 14px;
            /*font-weight: bold;*/
            margin-right: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            white-space: nowrap;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            text-align: center;
        }
        .total-row td {
            font-weight: bold;
            text-align: left;
        }
        .header img{
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }
        .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

    </style>
    <style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

 <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('orders')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header>

<!-- Report Title -->
<h3 class="report-title">Today's Order</h3>
<?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('todays_order')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="<?php echo e(request('start_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="<?php echo e(request('end_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
     
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('todays_order')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>
<!-- Report Date -->
<!-- <p class="report-date">Date: <?php echo e(date('d-m-Y')); ?></p> -->

<!-- Order Table -->
<table>
    <thead>
        <tr>
            <th>Order No</th>
            <th>Order Date</th>
            <th>Customer Name</th>
            <th>Order Amount</th>
             <th>Order Status</th>
             <th>Payment Status</th>
            
        </tr>
    </thead>
    <tbody>
        <?php
            $grand_total = 0;
            $advance = 0;
        ?>
        <?php if(isset($orders) && count($orders) > 0): ?>
            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $grand_total += $order->grandtotal;
                $advance += $order->advance;
            ?>
            <tr>
                <td><?php echo e($order->order_code); ?></td>
                <td><?php echo e(date('d-m-Y',strtotime($order->order_date))); ?></td>
                 <td><?php echo e($order->customer_name); ?></td>
                <td><?php echo e($order->grandtotal); ?></td>
                 <td><?php echo e($order->status); ?></td>
                  <td><?php echo e($order->payment_status); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="6" style="text-align: center; padding: 15px; font-style: italic;">
                    No data available to display.
                </td>
            </tr>
        <?php endif; ?>  
    </tbody>

    <!-- Total Row -->
    <tfoot>
        <tr class="total-row">
            <td colspan="3">Order Total</td>
            <!-- <td><?php echo e(number_format($advance, 2)); ?></td> -->
             <td><?php echo e(number_format($grand_total, 2)); ?></td>  
             <td colspan="2"></td>
            
        </tr>
    </tfoot>
</table>
  <br>
  <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('todays_order_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date')])); ?>">Download</a>
     <button type="button" class="custom-button" onclick="window.print()">Print</button>
         <?php endif; ?>
</body>
</html>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/todaysOrder.blade.php ENDPATH**/ ?>