<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Customerwise Receipt Details</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 14px;
        }
        .header {
            display: flex;
               justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        .logo {
            width: 150px;    
            margin-right: 20px;
            margin-bottom: 10px;
        }
        .address {
            font-size: 14px;
            line-height: 1.5;
            text-align: right;
        }
        .title {
            text-align: center;
            margin: 20px 0;
            font-size: 18px;
            font-weight: bold;
        }
        .date-title {
            margin-top: -60px;
        }
        .customer-name {
            font-size: 14px;
            font-weight: bold;
            margin-top: 10px;
            text-decoration: underline; 
        }
        table {
            width: 100%;
            margin-bottom: 15px;
            border-collapse: collapse;
            table-layout: fixed;
            word-wrap: break-word;
        }
        th, td {
            padding: 5px;
            vertical-align: top;
            font-size: 14px;
            /*border: 1px solid #000;*/
        }
        th {
            text-align: left;
            text-decoration: underline;
        }
        .row-divider {
            height: 1px;
            background: #ccc;
            margin: 10px 0;
        }
        .footer {
            position: fixed;
            bottom: 15px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #777;
        }
         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

     .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

    </style>

    <style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>


</head>
<body>

    <div class="header">
        <div class="logo">
            <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 100%;"><br><br><br>
            <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('orders')); ?>" class="back-button">Back</a>
           <?php endif; ?>
        </div>
        <div class="address" >
            <strong>Kukreja Interiors</strong><br>
            A-45, R Quarters, Near Sai Chowk, Pimpri,<br>
            Pune - 411017 Maharashtra, India<br>
            Phone : +91 96650 65522<br>
            Email : kukreja_interiors@yahoo.com
        </div>
    </div><hr style="color: whitesmoke;">

    <div class="title">Customerwise Receipt Details</div>
    <br>
    <?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('customer_receipt')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="<?php echo e(request('start_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="<?php echo e(request('end_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="payment_mode" style="margin-bottom: 0; font-size:15px"><b>Payment Mode:</b></label>
<select name="payment_mode" id="payment_mode"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
    <option value="">Select</option>
    <option value="Bank Transfer" <?php echo e(request('payment_mode') == 'Bank Transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
    <option value="Cash" <?php echo e(request('payment_mode') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
    <option value="Online" <?php echo e(request('payment_mode') == 'Online' ? 'selected' : ''); ?>>Online</option>
    <option value="Cheque" <?php echo e(request('payment_mode') == 'Cheque' ? 'selected' : ''); ?>>Cheque</option>
</select>
<label for="bank" style="margin-bottom: 0; font-size:15px"><b>Order No:</b></label>
    <select name="order"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($row->id); ?>" <?php echo e(request('order') == $row->id ? 'selected' : ''); ?>>
                <?php echo e($row->order_code); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>

      <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($row->id); ?>" <?php echo e(request('customer') == $row->id ? 'selected' : ''); ?>><?php echo e($row->customer_name); ?></option>
       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('customer_receipt')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>
 <hr>
    <br>
    <?php
        $today = \Carbon\Carbon::now()->setTimezone('Asia/Kolkata')->toDateString();
    ?><br>

    <!-- <div class="date-title"><?php echo e(\Carbon\Carbon::parse($today)->format('d-M-Y')); ?></div> -->

    <?php
        $grandTotal = 0;
        $headerShown = false;
    ?>

    <?php $__currentLoopData = $groupedReceipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $date => $customers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerName => $receipts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $customer = $receipts->first();
                $customerTotal = $receipts->sum('pay_amount');
                $grandTotal += $customerTotal;
            ?>

            <table>
                <?php if(!$headerShown): ?>
                <thead>
                    <tr>
                        <th>Receipt No</th>
                        <th>Order No</th>
                        <th>Invoice Date</th>
                        <th>Amount</th>
                        <th>Payment Mode</th>
                         <th>Details</th>
                        <th>Receipt Type</th>
                        <th>Order Status</th>
                        <th>Remark</th>
                    </tr>
                </thead>
                <?php $headerShown = true; ?>
                <?php endif; ?>

                <tbody>
                    <tr>
                        <td colspan="10" style="text-decoration: underline;"><?php echo e(\Carbon\Carbon::parse($date)->format('d-M-Y')); ?></td>
                    </tr>
                    <tr>
                        <td class="customer-name" colspan="10"><?php echo e($customer->customer_display_name); ?></td>
                    </tr>
                    <?php
                        $totalAmountSum = 0;
                    ?>

                    <?php $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $totalAmountSum += $receipt->pay_amount;
                        ?>
                        <tr>
                            <td><?php echo e($receipt->receipt_id); ?></td>
                            <td><?php echo e($receipt->order_code); ?></td>
                            <td><?php echo e(date('d-m-Y',strtotime($receipt->order_date))); ?></td>
                            <td><?php echo e(number_format($receipt->pay_amount, 2)); ?></td>
                            <td><?php echo e($receipt->payment_mode); ?></td>
                            <td>
                                    <?php if(!empty($receipt->bank_name)): ?>
                                        <b>Bank:</b> <?php echo e($receipt->bank_name); ?><br>
                                        <?php if(!empty($receipt->account_number)): ?>
                                            <b>Ac No:</b> <?php echo e($receipt->account_number); ?><br>
                                        <?php endif; ?>
                                        <?php if(!empty($receipt->ifsc_code)): ?>
                                            <b>IFSC:</b> <?php echo e($receipt->ifsc_code); ?><br>
                                        <?php endif; ?>
                                    <?php endif; ?>

                                    <?php if(!empty($receipt->reference_id)): ?>
                                        <b>Txn ID:</b> <?php echo e($receipt->reference_id); ?><br>
                                    <?php endif; ?>

                                    <?php if(!empty($receipt->cheque_number)): ?>
                                        <b>Cheque No:</b> <?php echo e($receipt->cheque_number); ?>

                                    <?php endif; ?>

                                    <?php if(empty($receipt->bank_name) && empty($receipt->reference_id) && empty($receipt->cheque_number)): ?>
                                        -
                                    <?php endif; ?>
                                </td>

                           
                            <td><?php echo e($receipt->receipt_type); ?></td>
                            <td><?php echo e($receipt->order_status); ?></td>
                            <td><?php echo e($receipt->remark); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="3"></td>
                        <td style="border-top:1px solid black;border-bottom:1px solid black;"><strong><?php echo e(number_format($totalAmountSum, 2)); ?></strong></td>
                        <td colspan="6"></td>
                    </tr>
                </tbody>
            </table>

            <div class="row-divider"></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div style="margin-top: 20px; font-weight: bold;">
        <span style="border-bottom: 5px double black; padding-bottom: 4px;">Grand Total : ₹<?php echo e(number_format($grandTotal, 2)); ?></span>
    </div>

    <div class="footer">
        Generated on <?php echo e(\Carbon\Carbon::now()->format('d M, Y h:i A')); ?>

    </div>
<br><br>
     <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('customer_receipt_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer'),'order' => request('order'),'payment_mode' => request('payment_mode')])); ?>">Download</a>
          <button type="button" class="custom-button" onclick="window.print()">Print</button>

         <?php endif; ?>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>

<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/customerreceiptdetails.blade.php ENDPATH**/ ?>