<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /Header -->
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .select2-container--default .select2-selection--single {
        
        border: 1px solid #e9edf6 !important;
        height:40px !important; 
       
    }
    .select2-container .select2-selection--single .select2-selection__arrow {
        height: 100% !important;
        position: absolute !important;
        top: 0 !important;
        right: 0 !important;
        width: 20px !important; 
        background-color: transparent !important;
        border-left: 1px solid #aaa !important; 
    }
    
    .select2-container .select2-selection__arrow b {
      
        border-width: 5px 5px 0 5px !important; 
        border-style: solid !important;
        display: inline-block !important;
        margin-top: 5px !important;
        vertical-align: middle !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow 
    {
        display: none !important;
    }
    .select2-selection__clear{
        display: none !important;
        /* color:#aaa; */
    }
    
    </style>
    
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Generate Tax Invoice</h4>
                    <h6></h6>
                </div>
            </div>
            <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="<?php echo e(route('orders')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Orders</a>
                    </div>
                </li>
            </ul>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
        <?php endif; ?>

        <form id="myForm" action="<?php echo e(route('save_taxinvoice')); ?>" method="post">
            <?php echo csrf_field(); ?>
     <input type="hidden" name="order_id" class="form-control" value="<?php echo e($order->id); ?>" readonly>

            <div class="card">
                <div class="card-body add-product pb-0">
                    <div class="accordion-card-one accordion" id="accordionExample">
                        <div class="accordion-item">
                            <div class="accordion-header" id="headingOne">
                                <div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-controls="collapseOne">
                                   
                                </div>
                            </div>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Invoice No</label>
                                                <input type="text" name="invoice_no" class="form-control" value="<?php echo e($invoiceNo); ?>" readonly>
                                            </div>
                                        </div>
                                               <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                               
                                                <label class="form-label">Customer</label>
                                               
                                                <select class="form-control" name="customer_id" id="customer_id" required>
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($row->id); ?>" data-gst="<?php echo e($row->gst_number); ?>" <?php echo e($row->id == $order->customer_id ? 'selected' : ''); ?>>
                                                                <?php echo e($row->customer_name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">GST No</label>
                                                  <input type="text" name="gst" class="form-control" value="<?php echo e($order->gst_number); ?>" readonly>
                                            </div>
                                        </div>
                                          <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Order No</label>
                                                  <input type="text" name="order_code" class="form-control" value="<?php echo e($order->order_code); ?>" readonly>
                                            </div>
                                        </div>
                                          <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Order Date</label>
                                                  <input type="text" name="order_date" class="form-control" value="<?php echo e($order->order_date); ?>" readonly>
                                            </div>
                                        </div>
                                         <div class="col-lg-2 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">GST Type</label>
                                                  <input type="text" name="gst_type" class="form-control"  readonly>
                                            </div>
                                        </div>
                                 
                                          
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <h5>Order Items</h5>
                                            <div class="table-responsive">
                                                <table class="table table-bordered" id="order-items">
                                                    <thead>
                                                        <tr>
                                                            <th style="width:20%">Description</th>
                                                             <th>Quantity</th>
                                                            <th>GST%</th>
                                                            <th>GST</th>
                                                            <th>Rate</th>
                                                            <th>Amount</th>
                                                            <th>HSN Code</th>
                                                            <th>UoM</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                         <?php 
                                                         $baseamount = 0;
                                                         $totalgst = 0;
                                                         $gst_5 = 0.00;
                                                         $gst_12 = 0.00;
                                                         $gst_18 = 0.00;
                                                         $gst_28 = 0.00;
                                                         $netbillamount = 0;
                                                       

                                                         ?>
                                                         <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                         <?php 
                                                       
                                                         $total= $item->quantity*$item->price;
                                                         $gstamt=$total*$item->gst_rate/100;
                                                         $baseamount += $total;
                                                         $totalgst +=  $gstamt;
                                                         
                                                         if ($item->gst_rate == 5.00) {
                                                                $gst_5 += $gstamt;
                                                            } elseif ($item->gst_rate == 12.00) {
                                                                $gst_12 += $gstamt;
                                                            } elseif ($item->gst_rate == 18.00) {
                                                                $gst_18 += $gstamt;
                                                            } elseif ($item->gst_rate == 28.00) {
                                                                $gst_28 += $gstamt;
                                                            }


                                                         ?>
                                                        <tr class="order-row">
                                                         
                                                            <td style="width:20%">
                                                                 <input type="text" name="description[]" class="form-control description" value="<?php echo e($item->varient_code); ?>-<?php echo e($item->varient_name); ?>" readonly>
                                                            </td>
                                                             <td><input type="text" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')" class="form-control quantity" value="<?php echo e($item->quantity); ?>" readonly></td>

                                                             <td>
                                                                  <input type="text" name="gst_percent[]" class="form-control gst_percent" value="<?php echo e($item->gst_rate); ?>" readonly>
                                                            </td>
                                                             <td>
                                                                <input type="text" name="gst_rate[]" class="form-control gst_rate" value="<?php echo e($gstamt); ?>"   readonly>
                                                            </td>
                                                              <td>
                                                                <input type="text" name="rate[]" class="form-control rate" value="<?php echo e(number_format($item->price, 2, '.', '')); ?>" readonly>
                                                            </td>
                                                            <td><input type="text" name="amount[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')" class="form-control amount" value="<?php echo e(number_format($total, 2, '.', '')); ?>" required></td>
                                                            <td><input type="text" name="hsncode[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')" class="form-control hsncode" value="<?php echo e($item->hsn_code); ?>" required></td>
                                                            <td><input type="text" name="uom[]" class="form-control uom" value="<?php echo e($item->unit_name); ?>" readonly></td>
                                                        </tr>
                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                         <?php
                                                             $netbillamount = $baseamount + $totalgst;
                                                         ?>


                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                  

                                    <div class="row">
                                        <!-- Empty offset for first 4 columns -->
                                        <div class="col-lg-4"></div>

                                       <div class="col-lg-4">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST @ 5%:</label>
                                                <input type="number" name="gst_5" class="form-control" value="<?php echo e(number_format($gst_5, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST @ 12%:</label>
                                                <input type="number" name="gst_12" class="form-control" value="<?php echo e(number_format($gst_12, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST @ 18%:</label>
                                                <input type="number" name="gst_18" class="form-control" value="<?php echo e(number_format($gst_18, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST @ 28%:</label>
                                                <input type="number" name="gst_28" class="form-control" value="<?php echo e(number_format($gst_28, 2, '.', '')); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Total Amount:</label>
                                                <input type="number" name="total_amount" class="form-control grosstotal" value="<?php echo e(number_format($baseamount, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Base Amount:</label>
                                                <input type="number" name="base_amount" class="form-control grosstotal" value="<?php echo e(number_format($baseamount, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST:</label>
                                                <input type="number" name="gst_amount" class="form-control grosstotal" value="<?php echo e(number_format($totalgst, 2, '.', '')); ?>" readonly>
                                            </div>
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Net Bill Amount:</label>
                                                <input type="number" name="net_amount" class="form-control grandtotal" value="<?php echo e(number_format($netbillamount, 2, '.', '')); ?>" readonly>
                                            </div>
                                        </div>

                                       
                                        
                                    </div>

                                    
                               

                                </div>
                            </div>
                        </div>
                    </div>
                </div><br>
                <div class="col-lg-12">
                    <div class="btn-addproduct mb-4">
                        <button type="button" class="btn btn-cancel me-2">Cancel</button>
                        <button type="submit" id="submitBtn" class="btn btn-primary">Save</button>
                    </div>
                </div>
            </div>

            
        </form>

    </div>
</div>




<!--end modal-->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>




<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
$(document).ready(function () {

    
    document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    

  
    $('#customer_id').select2({
        placeholder: "Select Customer",   
        allowClear: true,
		search:true,
		          
    });

  
        
});


function updateGstType() {
    var gstNo = $('input[name="gst"]').val(); 
    var gstTypeField = $('input[name="gst_type"]');

    if (gstNo && gstNo !== '') {
        if (gstNo.startsWith('27')) {
            gstTypeField.val('CGST + SGST');
        } else {
            gstTypeField.val('IGST');
        }
    } else {
        gstTypeField.val('');
    }
}


$(document).ready(function() {
    updateGstType(); 

    $('#customer_id').on('change', function() {
        var gstNo = $('#customer_id option:selected').data('gst') || '';
        $('input[name="gst"]').val(gstNo); 
        updateGstType(); 
    });
});


</script>



<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/admin/generate_taxinvoice.blade.php ENDPATH**/ ?>