<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Day Sales Report</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: Arial, sans-serif;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            border: 2px solid black; /* Outer Border */
        }

        th, td {
            text-align: left;
            padding: 10px;
            font-size: 16px;
            border: 1px solid black; /* Cell Borders */
        }

        th {
            background-color: #f2f2f2;
            text-decoration: underline;
        }

        .header-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 20px;
        }

        .company-info {
            text-align: right;
            font-size: 14px;
        }

        .section-title {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
        }

        .supplier-header {
            font-size: 18px;
            font-weight: bold;
            background-color: #f9f9f9;
            text-align: center;
        }
    </style>
</head>
<body>

<header class="header-container">
    <div>
        <img src="assets/img/report_images/img.png" alt="Company Logo" height="50px" width="200px">
    </div>
    <div class="company-info">
        <b>
            XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324
        </b>
    </div>
</header>

<h2 class="section-title">Stock Supplier</h2>
<b><?php echo e(date('Y-m-d')); ?></b>

<section>
    <table>
        <tr>
            <th><u>Stock</u></th>
            <th>Avl Quantity</th>
            <th>QOH</th>
            <th>CP</th>
            <th>Total Amount</th>
        </tr>
        <?php
            $total = 0;
        ?>
        <?php $__currentLoopData = $product_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Timberland Section -->
        <tr class="supplier-header">
            <td colspan="5"><b><?php echo e($items['product_name']); ?></b></td>
        </tr>
        <?php $__currentLoopData = $items['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $total += $item->purchase_cost ? $item->purchase_cost : 0;
        ?>
        <tr>
            <td><?php echo e($item->varient_code); ?>/<?php echo e($item->varient_name); ?></td>
            <td><?php echo e($item->quantity); ?></td>
            <td><?php echo e($item->qunatity_on_hand); ?></td>
            <td><?php echo e($item->basic_cost); ?></td>
            <td><?php echo e($item->purchase_cost); ?></td>
        </tr>
        
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td colspan="4" style="text-align: right;"><b>Total:</b></td>
            <td><u><b><?php echo e($total); ?></b></u></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
    </table>
</section>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/stocksupply.blade.php ENDPATH**/ ?>