<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Day Sales</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            border: 2px solid black;
            page-break-inside: auto;
        }

        th, td {
            border: 1px solid black;
            padding: 8px;
            font-size: 14px;
            text-align: left;
        }

        th {
            /*background-color: #f2f2f2;*/
            font-weight: bold;
            border-bottom: 2px solid black;
        }

        .total-row td {
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
        }

        .grand-total td {
            text-decoration: underline;
            text-decoration-style: double;
            text-underline-offset: 5px;
            font-weight: bold;
            text-align: right;
            border-top: 2px solid black;
            border-bottom: 2px solid black;
        }

        tr, td, th {
            page-break-inside: avoid;
        }

        tr.total-row td[colspan], tr.grand-total td[colspan] {
            border-right: 1px solid black;
            border-left: 1px solid black;
        }

       

        .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }
        hr{
            border: 1px solid black;
            margin-bottom: 15px;
        }

         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

      .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}


    </style>
    <style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>

  <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('orders')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header>
    <hr style="color: whitesmoke;">


<h2 class="section-title">Daily Sales Report</h2>
<!-- <?php echo e(date('d-M-Y')); ?><br> --><br>
   <?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('day_sales')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="<?php echo e(request('start_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="<?php echo e(request('end_date') ?? date('Y-m-d')); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
           <label for="payment_mode" style="margin-bottom: 0; font-size:15px"><b>Payment Mode:</b></label>
<select name="payment_mode" id="payment_mode"
        style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
    <option value="">Select</option>
    <option value="Bank Transfer" <?php echo e(request('payment_mode') == 'Bank Transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
    <option value="Cash" <?php echo e(request('payment_mode') == 'Cash' ? 'selected' : ''); ?>>Cash</option>
    <option value="Online" <?php echo e(request('payment_mode') == 'Online' ? 'selected' : ''); ?>>Online</option>
    <option value="Cheque" <?php echo e(request('payment_mode') == 'Cheque' ? 'selected' : ''); ?>>Cheque</option>
</select>
<label for="bank" style="margin-bottom: 0; font-size:15px"><b>Order No:</b></label>
    <select name="order"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($row->id); ?>" <?php echo e(request('order') == $row->id ? 'selected' : ''); ?>>
                <?php echo e($row->order_code); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
      <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Customer:</b></label>
    <select name="customer"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">Select</option>
        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($row->id); ?>" <?php echo e(request('customer') == $row->id ? 'selected' : ''); ?>><?php echo e($row->customer_name); ?></option>
       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('day_sales')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>


<section style="margin-top: 25px;">
    <table>
        <thead>
            <tr>
                <th>Order No</th>
                <th>Customer Name</th>
                  <th>Transaction Date</th>
                <th>Amount</th>
                <th>Bill No</th>
              
                <th>Payment Details</th>
                <th>Remarks</th>
                
                <th>Receipt Type</th>
            </tr>
        </thead>
        <tbody>
            <?php $grandTotal = 0; ?>

            <?php $__currentLoopData = $grouped_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod => $customers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="8" style="background-color: #d9edf7; font-weight: bold; text-align: center;">
                        Payment method - <?php echo e(strtoupper($paymentMethod)); ?>

                    </td>
                </tr>

                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customerName => $details): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="8" style="font-weight: bold;"><?php echo e(ucfirst($customerName)); ?></td>
                    </tr>

                    <?php $customerTotal = 0; ?>
                    <?php $__currentLoopData = $details['orders']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($order['order_code']); ?></td>
                            <td><?php echo e(ucfirst($customerName)); ?></td>
                              <td><?php echo e(date('d-m-Y',strtotime($order['transaction_date']))); ?></td>
                            <td><?php echo e(number_format(floatval(str_replace(',', '', $order['amount'])), 2)); ?></td>
                            <td><?php echo e($order['receipt_id']); ?></td>
                           
                             <td> <?php if(!empty($order['bank'])): ?>
                                <b>Bank:</b> <?php echo e($order['bank']); ?><br>
                                <b>Ac No:</b> <?php echo e($order['account_number'] ?? '-'); ?><br>
                                <b>IFSC:</b> <?php echo e($order['ifsc_code'] ?? '-'); ?><br>
                            <?php endif; ?>

                            <?php if(!empty($order['reference_id'])): ?>
                                <b>Txn ID:</b> <?php echo e($order['reference_id']); ?><br>
                            <?php endif; ?>

                            <?php if(!empty($order['cheq_no'])): ?>
                                <b>Cheque No:</b> <?php echo e($order['cheq_no']); ?>

                            <?php endif; ?>

                            <?php if(empty($order['bank']) && empty($order['reference_id']) && empty($order['cheq_no'])): ?>
                                -
                            <?php endif; ?></td>
                            <td><?php echo e($order['remark']); ?></td>
                            
                            <td><?php echo e($order['rcpt_type']); ?></td>
                        </tr>
                        <?php $customerTotal += floatval(str_replace(',', '', $order['amount'])); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <tr class="total-row">
                        <td colspan="7" style="text-align: right;"><b>Subtotal for <?php echo e(ucfirst($customerName)); ?>:</b></td>
                        <td><b><?php echo e(number_format($customerTotal, 2)); ?></b></td>
                    </tr>

                    <?php $grandTotal += $customerTotal; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <tr class="grand-total">
                <td colspan="7" style="text-align: right;"><b>Grand Total:</b></td>
                <td><b><?php echo e(number_format($grandTotal, 2)); ?></b></td>
            </tr>
        </tbody>
    </table>
      <br>
  <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('day_sales_pdf',['start_date' => request('start_date'), 'end_date' => request('end_date'),'customer' => request('customer'),'order' => request('order'),'payment_mode' => request('payment_mode')])); ?>">Download</a>
          <button type="button" class="custom-button" onclick="window.print()">Print</button>

         <?php endif; ?>
</section>

</body>
</html>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/daysales.blade.php ENDPATH**/ ?>