<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reserved Stock</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 40px;
        }

        body {
            font-family: Arial, sans-serif;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            table-layout: fixed; /* Ensures uniform column widths */
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 8px;
            font-size: 16px;
            word-wrap: break-word; /* Prevents text overflow */
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 10px 20px;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .header div {
            text-align: right;
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }

    </style>
</head>
<body>
    <header class="header">
        <img src="assets/img/report_images/img.png" alt="Logo">
        <div>
            <b>XYZ Trading Pvt Ltd.</b> <br>
            33/2 Rayna Building, Balewadi <br>
            GST NO: 98751324680881324
        </div>
    </header>

    <h2 class="section-title">Reserved Stock</h2>
    <b><?php echo e(date('d-M-Y')); ?></b>

    <section style="margin-top: 20px;">
        <table>
            <thead>
                <tr>
                    <th>Order No</th>
                    <th>Roll No</th>
                    <th>Description</th>
                    <th>Quantity</th>
                    <th>Installer Status</th>

                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td rowspan="<?php echo e(count($item['order_items'])); ?>"><?php echo e($item['order_id']); ?></td>
                        <?php $firstRow = true; ?>
                        <?php $__currentLoopData = $item['order_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!$firstRow): ?>
                                <tr>
                            <?php endif; ?>
                                <td><?php echo e($order_detail->roll_id); ?></td>
                                <td><b><?php echo e($order_detail->customer_name); ?></b><br><?php echo e($order_detail->varient_name); ?></td>
                                <td><?php echo e($order_detail->total_quantity); ?></td>
                                <td><?php echo e($order_detail->installer_status); ?></td>
                            </tr>
                            <?php $firstRow = false; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </section>
</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/reservedstocks.blade.php ENDPATH**/ ?>