<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>			
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <style>
        .invoice-box {
            background: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            max-width: 1000px;
            margin: auto;
            width: 100%;
        }
        .invoice-title {
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 20px;
        }
        .invoice-section-title {
            font-weight: 600;
            margin-top: 30px;
            margin-bottom: 10px;
            color: #343a40;
        }
        table th, table td {
            vertical-align: middle !important;
            line-height: 5px !important;
        }
        .text-right {
            text-align: right;
        }
        .btn-download {
            margin-top: 10px;
            text-align: right;
            background: white;
        }
        .btn-download:hover{
        	background: white;
        }

        ul.terms {
	        font-size: 12px;
	        color: #666;
	        padding-left: 0px;
	        margin-top: 10px;
	    }
    </style>
<div class="page-wrapper">
	<div class="content">
		<div class="page-header">
		    <div class="invoice-box">
		        <div class="row mb-0 align-items-center">
				    <!-- Logo on the Left -->
				    <div class="col-md-2 text-left">
				        <img src="<?php echo e(url('assets/img/logo.png')); ?>" alt="Company Logo" style="max-height: 35px;">
				    </div>

				    <!-- Invoice Title Centered -->
				    <div class="col-md-8 text-center">
				        <h2 class="invoice-title mb-2">INVOICE</h2>
				    </div>

				    <!-- Empty column to balance layout (optional) -->
				    <div class="col-md-2"></div>

				    <?php
				        $result = $groupedData->first();
				        if ($result && $result->count()) {
				            $result = $result->first();
				        }
				    ?>
				</div>
				<hr>


		        <div class="row mb-0">
		        	<div class="col-md-6 ">
		                <p class="mb-2"><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($result->order_date)->format('d M, Y')); ?></p>
		            </div>

		            <div class="col-md-6 text-end">
		                <p><strong>INVOICE NO :</strong> INV-<?php echo e($result->order_id ?? '0001'); ?></p>
		            </div>
		        </div>
		        <hr class="mb-0">

		        <div class="row mb-4">
		            <div class="col-md-8">
		                <h5 class="invoice-section-title">From</h5>
		                <p>
						    <strong>Kukreja Interiors</strong><br>
						    A-45, R Quarters,
						    Near Sai Chowk, Pimpri,<br>
						    Pune - 411017
						    Maharashtra, India<br>
						    Phone : <a href="tel:+919665065522">+91 96650 65522</a><br>
						    Email : <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a><br>
						    <!-- <b>GSTIN :</b> 1234567<br>
						    <b>PAN :</b> 12355655 -->
						</p>

		            </div>
		            <div class="col-md-4">
		                <h5 class="invoice-section-title">To</h5>
		                <?php
						    $result = $groupedData->first();
						    if ($result && $result->count()) {
						        $result = $result->first();
						    }
						?>

						<?php if($result): ?>
						<p>
						    <strong>Customer Name :</strong> <?php echo e($result->customer_name ?? 'N/A'); ?><br>
						    <strong>Address :</strong> <?php echo e($result->address ?? 'N/A'); ?><br>
						    <strong>City :</strong> <?php echo e($result->city ?? 'N/A'); ?><br>
						    <strong>State :</strong> <?php echo e($result->state ?? 'N/A'); ?><br>
						    <strong>Mobile :</strong>
						    <?php if(!empty($result->mobile)): ?>
						        <a href="tel:<?php echo e($result->mobile); ?>"><?php echo e($result->mobile); ?></a>
						    <?php else: ?>
						        N/A
						    <?php endif; ?><br>
						    <strong>Email : </strong> <?php echo e($result->email ?? 'N/A'); ?><br> 
						</p>

						<?php else: ?>
						<p>No customer data available.</p>
						<?php endif; ?>

		            </div>
		        </div><hr class="mb-0">	

		        <h5 class="invoice-section-title">Items</h5>
				    <table class="table table-bordered">
				        <thead>
				            <tr>
				                <th>#</th>
				                <th>Item Name</th>
				                <th>HSN code</th>
				                <th>Item Variants</th>
				                <th>Quantity</th>
				                <th>Unit Price</th>
				                <th>Total</th>
				            </tr>
				        </thead>
				        <tbody>
				            <?php
				                $subtotal = 0;
				                $sr_no = 0;
				            ?>
				            <?php $__currentLoopData = $groupedData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderId => $orderItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					            <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					                <?php
					                	$sr_no++;
					                    $lineTotal = $item->quantity * $item->price;
					                    $subtotal += $lineTotal;
					                ?>
					                <tr>
					                    <td><?php echo e($sr_no); ?></td>
					                    <td><?php echo e($item->product_name); ?></td>
					                    <td><?php echo e($item->hsn_code); ?></td>
					                    <td>
					                        <?php if($item->varient_name): ?>
					                            <?php echo e($item->varient_name); ?> - <?php echo e($item->varient_code); ?>

					                        <?php else: ?>
					                            No variants
					                        <?php endif; ?>
					                    </td>
					                    <td><?php echo e($item->quantity); ?></td>
					                    <td>₹<?php echo e(number_format($item->price, 2)); ?></td>
					                    <td>₹<?php echo e(number_format($lineTotal, 2)); ?></td>
					                </tr>
					            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				        </tbody>
				    </table>

				    
				<?php
					$gstRate = 18; // Example GST rate

					// Assuming intra-state supply: GST = CGST + SGST (each 9%)
					$cgstRate = $gstRate / 2;
					$sgstRate = $gstRate / 2;

					$cgstAmount = ($subtotal * $cgstRate) / 100;
					$sgstAmount = ($subtotal * $sgstRate) / 100;

					// Assuming IGST is not applicable (or if applicable, you can replace CGST+SGST with IGST)
					$igstRate = 0;
					$igstAmount = 0;

					$grandTotal = $subtotal + $cgstAmount + $sgstAmount + $igstAmount;
				?>

				
				<div class="row justify-content-end mt-3 mb-0">
					<div class="col-md-6">
						<table class="table table-bordered">
							<tr>
								<th class="fw-bold">Subtotal</th>
								<td class="text-end">₹<?php echo e(number_format($subtotal, 2)); ?></td>
							</tr>

							<?php if($cgstAmount > 0): ?>
							<tr>
								<th class="fw-bold">CGST (<?php echo e($cgstRate); ?>%)</th>
								<td class="text-end">₹<?php echo e(number_format($cgstAmount, 2)); ?></td>
							</tr>
							<?php endif; ?>

							<?php if($sgstAmount > 0): ?>
							<tr>
								<th class="fw-bold">SGST (<?php echo e($sgstRate); ?>%)</th>
								<td class="text-end">₹<?php echo e(number_format($sgstAmount, 2)); ?></td>
							</tr>
							<?php endif; ?>

							<?php if($igstAmount > 0): ?>
							<tr>
								<th class="fw-bold">IGST (<?php echo e($igstRate); ?>%)</th>
								<td class="text-end">₹<?php echo e(number_format($igstAmount, 2)); ?></td>
							</tr>
							<?php endif; ?>

							<tr>
								<th style="font-size: 15px;"><strong>Grand Total</strong></th>
								<td class="text-end"><strong>₹<?php echo e(number_format($grandTotal, 2)); ?></strong></td>
							</tr>
						</table>
					</div>
				</div>

				<br>
				<hr>

				<!-- Notes & Terms -->
				<div class="row">
				    <div class="col-md-6">
				        <!-- Notes Section -->
				        <div class="invoice-section-title">Notes</div>
				        <p style="font-size: 13px;">
				            Thank you for your purchase.<br>
				            For questions about this invoice, please reach out using the contact details provided below.
				        </p>
				    </div>
				    <div class="col-md-6">
				        <!-- Terms & Conditions -->
				        <div class="invoice-section-title">Terms & Conditions</div>
				        <ul class="terms" style="font-size: 13px; padding-left:0px; margin-bottom: 0;">
				            <li>Payment due within 15 days from invoice date.</li>
				            <li>Goods once sold will not be taken back or exchanged.</li>
				            <li>All disputes are subject to Pune jurisdiction only.</li>
				        </ul>
				    </div>
				</div>

				<hr style="margin: 20px 0;">

				<!-- Footer Info & Signature -->
				<div class="row" style="margin-top: 10px;">
				    <div class="col-md-6">
				        <!-- Footer Contact Info -->
				        <div class="footer" style="font-size: 12px; color: #666;">
				            <p style="margin-bottom: 4px;">Kukreja Interiors</p>
				            <p style="margin-bottom: 4px;">A-45, R Quarters, Near Sai Chowk, Pimpri, Pune - 411017</p>
				            <p style="margin-bottom: 4px;">Email: <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a></p>
				            <p style="margin-bottom: 4px;">Phone: <a href="tel:+919665065522">+91 96650 65522</a></p>
				            <p style="margin-bottom: 4px;">GSTIN: 27ABCPK1234A1ZB | PAN: ABCPK1234A</p>
				        </div>
				    </div>

				    <div class="col-md-6" style="text-align: right;">
				        <!-- Authorized Signatory -->
				        <div class="invoice-section-title mb-0">Authorized Signatory</div>
				        <p style="margin: 40px 0 5px;">_________________________</p>
				        <p style="font-size: 13px;">Name & Designation</p>
				        <p style="font-size: 11px; color: #888;">(This is a computer-generated invoice and does not require a physical signature)</p>
				    </div>
				</div>
				<hr>
		        <div class="btn-download text-end mt-3">
			        <a href="<?php echo e(route('download-invoice', ['productId' => $result->product_id])); ?>" class="btn btn-primary btn-sm">
			            <i class="fas fa-file-pdf"></i> Download PDF
			        </a>
			    </div>
		    </div>
		</div>
	</div>
</div>
<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/admin/view-invoice.blade.php ENDPATH**/ ?>