<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		<!-- /Header -->
		<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

		<div class="page-wrapper">
			<div class="content">
				<div class="page-header">
					<div class="add-item d-flex">
						<div class="page-title">
							<h4>Add Coupon</h4>
							<h6>Create new coupon</h6>
						</div>
					</div>
					<ul class="table-top-head">
						<li>
							<div class="page-btn">
								<a href="<?php echo e(route('coupons')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Coupons</a>
							</div>
						</li>
						<li>
							<a data-bs-toggle="tooltip" data-bs-placement="top" title="Collapse" id="collapse-header"><i data-feather="chevron-up" class="feather-chevron-up"></i></a>
						</li>
					</ul>
					
				</div>
				<?php if(session()->has('success')): ?>
							<div class="alert alert-success">
								<?php echo e(session()->get('success')); ?>

							</div>
							<?php endif; ?>
							<?php if(session()->has('error')): ?>
							<div class="alert alert-danger">
								<?php echo e(session()->get('error')); ?>

							</div>
						    <?php endif; ?>
				<!-- /add -->
				<form action="<?php echo e(route('save_coupon')); ?>" id="myForm" method="post" enctype="multipart/form-data">
					<?php echo csrf_field(); ?>
					<div class="card">
						<div class="card-body add-product pb-0">
							<div class="accordion-card-one accordion" id="accordionExample">
								<div class="accordion-item">
									<div class="accordion-header" id="headingOne">
										<div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne"  aria-controls="collapseOne">
											<div class="addproduct-icon">
												<h5><i data-feather="info" class="add-info"></i><span>Coupon  Information</span></h5>
												<a href="javascript:void(0);"><i data-feather="chevron-down" class="chevron-down-add"></i></a>
											</div>
										</div>
									</div>
									<div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
									<div class="accordion-body">
										
										<div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Coupon Code</label>
													<input type="text" name="coupon_code" id="couponcode" class="form-control" placeholder="Enter Coupon Code" required><small id="coupon-error" style="color: red; display: none;">This coupon is already added!</small>
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Discount Type</label>
													<select class="select" name="discount_type" required >
													
						        <option value="">Select </option>
                                                        <option value="percentage">Percentage </option>
                                                        <option value="fixed">Fixed </option>
												
												</select>
												</div>
											</div>
                                            <div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Discount Value</label>
													<input type="text" name="discount_value" class="form-control" >
												</div>
											</div>
                                        </div>
                                        <div class="row">
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Start Date</label>
													<input type="date" name="start_date" class="form-control" placeholder="Enter Start Date">
												</div>
											</div>
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">End Date</label>
													<input type="date" name="end_date" class="form-control" placeholder="Enter End Date">
												</div>
											</div>
											
											<div class="col-lg-4 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Coupon Image</label>
													<input type="file" name="coupon_image" class="form-control" accept=".jpg,.jpeg,.png">
												</div>
											</div>
										</div>

										<div class="row">
											
											
											<div class="col-lg-12 col-sm-6 col-12">
												<div class="mb-3 add-product">
													<label class="form-label">Description</label>
													<input type="text" name="description" class="form-control" placeholder="Enter Description" >
												</div>
											</div>
											
											
										</div>

									

										
									</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
					<div class="col-lg-12">
						<div class="btn-addproduct mb-4">
							<a href="<?php echo e(route('coupons')); ?>" class="btn btn-cancel me-2">Cancel</a>
							<button type="submit" id="submitBtn" class="btn btn-submit">Save Coupon</button><p id="message" style="color: red;">
						</div>
					</div>
				</form>
			<!-- /add -->

		</div>
	</div>
	</div>
	<!-- /Main Wrapper -->

	<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<script>
	 document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    
     $("#couponcode").on("keyup blur", function (e) { 
        let coupon = $(this).val();
       
            $.ajax({
                url: "<?php echo e(route('check_coupon_exists')); ?>",
                type: "POST",
                data: {
                    coupon: coupon,
                    _token: "<?php echo e(csrf_token()); ?>"
                },
                success: function (response) {
                    if (response.exists) {
                        $("#coupon-error").show(); 
                        $("#couponcode").addClass("error-field"); 
                        $("#couponcode").focus(); 
                         $("#submitBtn").prop("disabled", true);
                        $("#message")
            .text("This coupon name is already used, try another.")
            .css({ "color": "red", "font-weight": "bold", "display": "block", "visibility": "visible" })
            .show();
                    } else {
                        $("#coupon-error").hide(); 
                        $("#couponcode").removeClass("error-field"); 
                    }
                }
            });
            $("#submitBtn").prop("disabled", false);
         $("#message").hide();
        
    });
    
    $("#couponcode").on("keydown", function (e) {
        if (e.key === "Tab" && $("#coupon-error").is(":visible")) {
            e.preventDefault(); 
        }
    });
    
    </script>
<?php /**PATH /var/www/ff-live/fflive/resources/views/admin/add-coupon.blade.php ENDPATH**/ ?>