<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reserved Stock</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 40px;
        }

        body {
            font-family: DejaVu Sans, Arial, sans-serif;
            font-size: 14px;
            color: #000;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            table-layout: fixed; /* Ensures uniform column widths */
        }

        th, td {
            border: 1px solid black;
            text-align: left;
            padding: 8px;
            font-size: 14px;
            word-wrap: break-word; /* Prevents text overflow */
        }

        th {
            /*background-color: #f2f2f2;*/
            font-weight: bold;
        }

        .header {
        display: flex;
        justify-content: space-between;
        align-items: flex-start;
        margin-bottom: 20px;
    }

    .logo-section {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
        gap: 10px;
    }

        .header img {
            height: 50px;
            width: 170px;
            margin-bottom: 7px;
        }

        .header div {
            /*text-align: right;*/
        }

        .section-title {
            text-align: center;
            margin-top: 10px;
        }
        hr{
            border: 1px solid black;
            margin-top: 10px;    
        }

         .custom-button {
      background-color: #4CAF50; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .custom-button:hover {
      background-color: #45a049;
    }

      .back-button {
      background-color: blueviolet; /* Green */
      border: none;
      color: white;
      padding: 10px 20px;
      text-align: center;
      font-size: 16px;
      cursor: pointer;
      border-radius: 5px;
      transition: background-color 0.3s ease;
    }

    .back-button:hover {
      background-color: blueviolet;
    }

    .reset-button {
    background-color: #dc3545; /* Bootstrap red */
    border: none;
    color: white;
    padding: 10px 20px;
    font-size: 16px;
    border-radius: 5px;
    text-decoration: none;
    text-align: center;
   
    display: flex;
    align-items: center;
    transition: background-color 0.3s ease;
}

.reset-button:hover {
    background-color: #c82333;
}

    </style>
    
<style>
@media  print {
    .custom-button, .reset-button, .back-button, form {
        display: none !important;
    }
}
</style>
</head>
<body>
    <header class="header">
    <div class="logo-section">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Logo" style="width: 150px;">
        <?php if(!$is_pdf): ?>
            <a href="<?php echo e(route('orders')); ?>" class="back-button">Back</a>
        <?php endif; ?>
    </div>
    <div style="line-height: 20px; text-align: right;">
        <b><?php echo e($company->company_name); ?></b> <br>
        <?php echo e($company->address); ?>, <?php echo e($company->city); ?>, <?php echo e($company->state); ?> <br>
        Phone: <?php echo e($company->phone1); ?> <br>
        GST NO: <?php echo e($company->gst_no); ?>

    </div>
</header><hr>

    <h2 class="section-title">Reserved Stock</h2>
    <!-- <?php echo e(date('d-M-Y')); ?> -->
   <?php if(!$is_pdf): ?>
   <form method="GET" action="<?php echo e(route('reserved_stocks')); ?>" style="display: flex; align-items: center; gap: 10px; margin-bottom: 20px;">
    <label for="start_date" style="margin-bottom: 0;font-size:15px"><b>Start Date:</b></label>
    <input type="date" name="start_date"
           value="<?php echo e(request('start_date', $start_date)); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    <label for="end_date" style="margin-bottom: 0;font-size:15px"><b>End Date:</b></label>
    <input type="date" name="end_date"
           value="<?php echo e(request('end_date', $end_date)); ?>"
           required
           style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 20px;">

    
       <label for="customer" style="margin-bottom: 0; font-size:15px"><b>Order No:</b></label>
    <select name="order_no"
            style="padding: 10px; font-size: 16px; border: 1px solid #ccc; border-radius: 5px; height: 40px;">
        <option value="">All</option>
        <?php $__currentLoopData = $orderno; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($row->id); ?>" <?php echo e($selected_order_no == $row->id ? 'selected' : ''); ?>><?php echo e($row->order_code); ?></option>
       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    
    </select>
           <button type="submit" class="custom-button">Filter</button>
     <a href="<?php echo e(route('reserved_stocks')); ?>" class="reset-button">Reset</a>
</form>
<?php endif; ?>


    <br>

    <section style="margin-top: 20px;">
    <table>
    <thead>
        <tr>
            <th>Order No</th>
            <th>Order Date</th>
            <th>Customer Name</th>
            <th>Roll No</th>
            <th>Description</th>
            <th>Quantity</th>
            <th>Order Status</th>
        </tr>
    </thead>
    <tbody>
        <?php if(count($order_items) > 0): ?>
            <?php $__currentLoopData = $order_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $firstRow = true; ?>
                <?php $__currentLoopData = $item['order_items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order_detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <?php if($firstRow): ?>
                            <td rowspan="<?php echo e(count($item['order_items'])); ?>"><?php echo e($item['order_id']); ?></td>
                            <td rowspan="<?php echo e(count($item['order_items'])); ?>">
                              <?php echo e(date('j M Y', strtotime($order_detail->order_date))); ?>


                            </td>
                            <td rowspan="<?php echo e(count($item['order_items'])); ?>"><?php echo e($order_detail->customer_name); ?></td>
                        <?php endif; ?>

                        <td><?php echo e($order_detail->roll_id); ?></td>
                        <td>
                            <b><?php echo e($order_detail->product_name); ?></b><br>
                            <?php echo e($order_detail->varient_code); ?>-<?php echo e($order_detail->varient_name); ?>

                        </td>
                        <td><?php echo e($order_detail->used_quantity); ?></td>

                        <?php if($firstRow): ?>
                            <td rowspan="<?php echo e(count($item['order_items'])); ?>"><?php echo e($order_detail->status); ?></td>
                        <?php endif; ?>
                    </tr>
                    <?php $firstRow = false; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <td colspan="7" style="text-align: center; font-style: italic;">No reserved stock data available.</td>
            </tr>
        <?php endif; ?>
    </tbody>
</table>


    </section><br><br>
      <?php if(!$is_pdf): ?>
         <a class="custom-button"  href="<?php echo e(route('reserved_stocks_pdf',['start_date' => request('start_date'),'end_date' => request('end_date'),'order_no' => request('order_no')])); ?>">Download</a>
            <button type="button" class="custom-button" onclick="window.print()">Print</button>

         <?php endif; ?>
</body>
</html>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const startDateInput = document.querySelector('input[name="start_date"]');
        const endDateInput = document.querySelector('input[name="end_date"]');

        function updateEndDateMin() {
            endDateInput.min = startDateInput.value;
            if (endDateInput.value < startDateInput.value) {
                endDateInput.value = startDateInput.value;
            }
        }

        // Run on load and on change
        startDateInput.addEventListener('change', updateEndDateMin);
        updateEndDateMin(); // Initial setup
    });
</script>


<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/reportstemplate/reservedstocks.blade.php ENDPATH**/ ?>