<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Today's Order</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        header {
            padding: 10px 20px;
            overflow: hidden;
            border-bottom: 2px solid black;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logo {
            width: 200px;
        }
        .company-details {
            text-align: right;
            max-width: 65%;
            font-size: 14px;
            line-height: 18px;
        }
        .report-title {
            text-align: center;
            text-decoration: underline;
            font-size: 20px;
            margin: 10px 0;
        }
        .report-date {
            text-align: right;
            font-size: 14px;
            font-weight: bold;
            margin-right: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            white-space: nowrap;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            text-align: center;
        }
        .total-row td {
            font-weight: bold;
            text-align: left;
        }
    </style>
</head>
<body>

<header>
    <div class="logo">
        <img src="assets/img/report_images/img.png" alt="Company Logo" height="50px" width="200px">
    </div>
    <div class="company-details">
        <b>XYZ Trading Pvt Ltd.</b><br>
        33/2 Rayna Building, Balewadi<br>
        GST NO: 98751324680881324
    </div>
</header>

<!-- Report Title -->
<h3 class="report-title">Today's Order</h3>

<!-- Report Date -->
<p class="report-date">Date: <?php echo e(date('d-m-Y')); ?></p>

<!-- Order Table -->
<table>
    <thead>
        <tr>
            <th>Order No</th>
            <th>Customer Name</th>
            <th>Advance</th>
            <th>Balance Amount</th>
        </tr>
    </thead>
    <tbody>
        <?php
            $grand_total = 0;
            $advance = 0;
        ?>
        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $grand_total += $order->grandtotal;
            $advance += $order->advance;
        ?>
        <tr>
            <td><?php echo e($order->id); ?></td>
            <td><?php echo e($order->customer_name); ?></td>
            <td><?php echo e($order->advance); ?></td>
            <td><?php echo e($order->grandtotal); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        
    </tbody>

    <!-- Total Row -->
    <tfoot>
        <tr class="total-row">
            <td colspan="2">Total</td>
            <td><?php echo e(number_format($advance, 2)); ?></td>
            <td><?php echo e(number_format($grand_total, 2)); ?></td>
        </tr>
    </tfoot>
</table>

</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/todaysorder.blade.php ENDPATH**/ ?>