<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bill NOT UPDATED</title>
    <style>
        @page  {
            size: A4 landscape;
            margin: 45px 40px 20px 40px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            text-align: left;
            padding: 5px;
            font-size: 16px;
            border: 1px solid black; /* Proper table alignment */
        }

        th {
            background-color: #f2f2f2;
        }

        .text-right {
            text-align: right;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .header img {
            height: 50px;
            width: 200px;
        }

        .title {
            text-align: center;
            font-weight: bold;
            font-size: 20px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <header class="header">
        <div><img src="assets/img/report_images/img.png" alt="Company Logo"></div>
        <div>
            <b>XYZ Trading Pvt Ltd.<br>
            33/2 Rayna Building, Balewadi<br>
            GST NO: 98751324680881324</b>
        </div>
    </header>

    <section style="margin-top: 30px;">
        <div class="title">BILL NOT UPDATED</div>
        <table>
            <tr>
                <th>Ord No</th>
                <th>Rcpt Dt</th>
                <th>Customer Name</th>
                <th>Amount</th>
                <th>Bill No</th>
                <th>Mode</th>
                <th>Bank</th>
                <th>Chq No</th>
                <th>Rcpt Type</th>
                <th>Remarks</th>
            </tr>

            <?php $grandTotal = 0; ?>
            <?php if(isset($order_receipts) && count($order_receipts) > 0): ?>
                <?php $__currentLoopData = $order_receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $grandTotal += (float) $receipt->total_amount; ?>
                    <tr>
                        <td><b><?php echo e($receipt->order_id); ?></b><br><?php echo e($receipt->payment_method); ?></td>
                        <td><?php echo e($receipt->transaction_date); ?></td>
                        <td><?php echo e($receipt->customer_name); ?></td>
                        <td class="text-right">
                            <?php echo e(number_format($receipt->total_amount, 2)); ?> <br>
                            <span style="font-size: 12px;"><?php echo e(number_format($receipt->amount_paid, 2)); ?></span>
                        </td>
                        <td><b><?php echo e($receipt->receipt_id); ?></b></td>
                        <td><b><?php echo e($receipt->payment_mode); ?></b></td>
                        <td><?php echo e($receipt->bank_name); ?></td>
                        <td><?php echo e($receipt->cheque_number); ?></td>
                        <td><?php echo e($receipt->receipt_type); ?></td>
                        <td><?php echo e($receipt->remark); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <tr>
                <td colspan="3" class="text-right"><b>Grand Total:</b></td>
                <td class="text-right" style="border-bottom-style: double; font-size: 20px;">
                    <b><?php echo e(number_format($grandTotal, 2)); ?></b>
                </td>
                <td colspan="6"></td>
            </tr>
        </table>
    </section>
</body>
</html>
<?php /**PATH /var/www/ff-live/fflive/resources/views/reportstemplate/billnotupdated.blade.php ENDPATH**/ ?>