<style>
    /* Basic reset and styling */
    body {
        font-family: Arial, sans-serif;
        font-size: 12px;
        line-height: 1.5;
        color: #333;
        margin: 0;
        padding: 0;
        page-break-before: auto;
    }

    .invoice-box {
        background: #fff;
        /*padding: 10px;*/
        /*border-radius: 8px;*/
        max-width: 800px;
        margin: 0 auto;
        /*width: 100%;*/
        box-sizing: border-box;
        border: 1px solid black;
        padding-left: 13px;
        padding-right: 13px;
    }

    /* Invoice Title */
    .invoice-title {
        text-align: center;
        font-size: 32px;
        font-weight: 700;
        color: #1a202c;
        margin-bottom: 20px;
        margin-top: -40px;
        text-transform: uppercase;
    }

    /* Invoice Header Section */
    

    .invoice-header td {
        font-size: 16px;
        color: #555;
    }

   


    /* Invoice Section Title */
    .invoice-section-title {
        font-weight: 700;
        margin-top: 25px;
        font-size: 16px;
        color: #444;
    }

    /* Table Styling */
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
    }

    table th, table td {
        padding: 12px;
        text-align: left;
        border: 1px solid black;
    }

    table th {
        font-size: 14px;
        color: #333;
    }

    table td {
        font-size: 14px;
        color: #555;
    }

    table td.text-right {
        text-align: right;
    }

    table td strong {
        font-weight: 600;
    }

    /* Footer Section */
    .footer {
        margin-top: 30px;
        font-size: 14px;
        color: #888;
        text-align: center;
    }

    .footer a {
        color: #2b6cb0;
        text-decoration: none;
        font-weight: 700;
    }

    /* Total Table */
    .total-table th, .total-table td {
        padding: 12px;
        text-align: right;
        border: 1px solid black;
        line-height: 8px !important;
    }
    table th{
        vertical-align: middle !important;
        line-height: 7px !important;
        white-space: nowrap;;
    }
    table td {
        vertical-align: middle !important;
        line-height: 18px !important;
    }
    .total-table th {
        /*font-weight: 600;*/   
        font-size: 14px;
    }

    .total-table td {
        font-size: 14px;
    }

    /* Page Break Handling */
    .page-break {
        page-break-before: auto;
        page-break-after: auto;
    }
    hr{
        color: whitesmoke;  
    }
    .invoice-details-div {
        display: flex;
        justify-content: space-between;  
        width: 100%; 
        padding-bottom: 10px;
    }

    .invoice-details-div p {
        margin: 0;  
        font-size: 14px; 
    }

    .invoice-details-div .invoice-date {
        text-align: left; 
        width: 45%;  
    }

    .invoice-details-div .invoice-no {
        text-align: right;  
        width: 100%; 
        margin-top: -200px;
    }

    /*invoice address styles*/
    .invoice-header{
        width: 100%;
        display: flex;
        justify-content: row;
        margin-top: 15px !important;
    }

    .from-address{
        width: 50%;
        float:left;
    }
    .to-address{
        width: 50%;
        float:right;
    }

    ul.terms {
        font-size: 12px;
        color: #666;
        padding-left: 15px;
        margin-top: 10px;
    }


</style>

<div class="invoice-box">
    <!-- Invoice Title -->
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <img src="https://fflive.omsdev.in/assets/img/logo.png" alt="Kukreja Interiors Logo" style="height: 35px; margin-top: 30px;">
        <div class="invoice-title">Invoice</div>
    </div>
    <hr>


    <!-- Invoice Details (Date, Invoice No) -->
    <div class="invoice-details-div">
        <?php
            $firstItem = $groupedData->first()->first();
        ?>
        <p class="invoice-date"><strong>Date:</strong> <?php echo e(\Carbon\Carbon::parse($firstItem->order_date)->format('d M, Y')); ?></p>
        <p class="invoice-no"><strong>INVOICE NO :</strong> INV-<?php echo e($firstItem->order_id ?? '0001'); ?></p>
    </div><hr>

   

    <!-- Invoice Header Section (From and To Address) -->
    <div class="invoice-header">
        <!-- From Address -->
        <div class="from-address">
            <strong class="invoice-section-title">From</strong><br>
            <p>
                <strong>Kukreja Interiors</strong><br>
                A-45, R Quarters,
                Near Sai Chowk, Pimpri,<br>
                Pune - 411017
                Maharashtra, India<br>
                Phone : <a href="tel:+919665065522">+91 96650 65522</a><br>
                Email : <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a><br>
                <!-- GSTIN : N/A<br>
                PAN : N/A -->
            </p>
        </div>

        <!-- Bill To Address -->
        <div class="to-address">
            <strong class="invoice-section-title">Bill To</strong><br>
            <?php
                $customer = $groupedData->first()->first();
            ?>
            <p>
                <strong><?php echo e($customer->customer_name ?? 'N/A'); ?>,</strong><br>
                <?php echo e($customer->address ?? 'N/A'); ?>,<br>
                <?php echo e($customer->city ?? 'N/A'); ?>, <?php echo e($customer->state ?? 'N/A'); ?>,<br>
                Phone: <?php echo e($customer->mobile ?? 'N/A'); ?>,<br>
                Email: <?php echo e($customer->email ?? 'N/A'); ?><br>
                <?php if(!empty($customer->gstin)): ?>
                    <strong>GSTIN:</strong> <?php echo e($customer->gstin); ?>

                <?php endif; ?>
            </p>
        </div>
    </div>



    <!-- Items Table -->
    <div class="invoice-section-title">Items</div>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Item Name</th>
                <th>HSN code</th>
                <th>Item Variants</th>
                <th>Quantity</th>
                <th>Unit Price</th>
                <th>Total</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $subtotal = 0;
            ?>
            <?php $__currentLoopData = $groupedData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderId => $orderItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $lineTotal = $item->quantity * $item->price;
                        $subtotal += $lineTotal;
                    ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($item->product_name); ?></td>
                        <td><?php echo e($item->hsn_code); ?></td>
                        <td>
                            <?php if($item->varient_name): ?>
                                <?php echo e($item->varient_name); ?> - <?php echo e($item->varient_code); ?>

                            <?php else: ?>
                                No variants
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($item->quantity); ?></td>
                        <td><?php echo e(number_format($item->price, 2)); ?></td>
                        <td><?php echo e(number_format($lineTotal, 2)); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <!-- Totals Section -->
    <?php
        $gstRate = 18;
        $cgstRate = $gstRate / 2;
        $sgstRate = $gstRate / 2;
        $cgstAmount = ($subtotal * $cgstRate) / 100;
        $sgstAmount = ($subtotal * $sgstRate) / 100;
        $totalGST = $cgstAmount + $sgstAmount;
        $grandTotal = $subtotal + $totalGST;
    ?>

    <table class="total-table">
        <tr>
            <th>Subtotal</th>
            <td><?php echo e(number_format($subtotal, 2)); ?></td>
        </tr>
        <tr>
            <th>CGST (<?php echo e($cgstRate); ?>%)</th>
            <td><?php echo e(number_format($cgstAmount, 2)); ?></td>
        </tr>
        <tr>
            <th>SGST (<?php echo e($sgstRate); ?>%)</th>
            <td><?php echo e(number_format($sgstAmount, 2)); ?></td>
        </tr>
        <tr>
            <th><strong>Grand Total</strong></th>
            <td><strong><?php echo e(number_format($grandTotal, 2)); ?></strong></td>
        </tr>
    </table>
    
    <!-- Notes Section -->
    <div class="invoice-section-title">Notes</div>
    <p>Thank you for your purchase. If you have any questions, please feel free to contact us.</p>

     <!-- Terms & Conditions -->
    <div class="invoice-section-title">Terms & Conditions</div>
    <ul class="terms">
        <li>Payment due within 15 days from invoice date.</li>
        <li>Goods once sold will not be taken back.</li>
        <li>All disputes are subject to Pune jurisdiction.</li>
    </ul>

    <!-- Authorized Signatory -->
    <div class="invoice-section-title mb-0">Authorized Signatory </div>
    <p>_________________________</p>
        
    

    <!-- Footer Section -->
    <div class="footer">
        <p>For any queries, please contact us at <a href="mailto:kukreja_interiors@yahoo.com">kukreja_interiors@yahoo.com</a></p>
        <!-- <p>Company Registration No: 12345678 | GSTIN: 123456789012345</p> -->
    </div>

    <!-- Computer Generated Note -->
    <p style="text-align: center; font-size: 11px; color: #888; margin-top: 10px;">
        <b>Note</b> :This is a computer-generated invoice and does not require a physical signature.
    </p>
</div>


<!-- Page Break for More Content -->
<div class="page-break"></div>
<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/admin/download-invoice.blade.php ENDPATH**/ ?>