<?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /Header -->
<?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<style>
    .select2-container--default .select2-selection--single {
        
        border: 1px solid #e9edf6 !important;
        height:40px !important; 
       
    }
    .select2-container .select2-selection--single .select2-selection__arrow {
        height: 100% !important;
        position: absolute !important;
        top: 0 !important;
        right: 0 !important;
        width: 20px !important; 
        background-color: transparent !important;
        border-left: 1px solid #aaa !important; 
    }
    
    .select2-container .select2-selection__arrow b {
      
        border-width: 5px 5px 0 5px !important; 
        border-style: solid !important;
        display: inline-block !important;
        margin-top: 5px !important;
        vertical-align: middle !important;
    }
    
    .select2-container--default .select2-selection--single .select2-selection__arrow 
    {
        display: none !important;
    }
    .select2-selection__clear{
        display: none !important;
        /* color:#aaa; */
    }
    #product_select{
        width: auto;
    }
    
    </style>
    
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="add-item d-flex">
                <div class="page-title">
                    <h4>Add Purchase Order</h4>
                    <h6>Create new purchase order</h6>
                </div>
            </div>
            <ul class="table-top-head">
                <li>
                    <div class="page-btn">
                        <a href="<?php echo e(route('purchase_orders')); ?>" class="btn btn-secondary"><i data-feather="arrow-left" class="me-2"></i>Back to Purchases</a>
                    </div>
                </li>
            </ul>
        </div>

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success"><?php echo e(session()->get('success')); ?></div>
        <?php endif; ?>
        <?php if(session()->has('error')): ?>
            <div class="alert alert-danger"><?php echo e(session()->get('error')); ?></div>
        <?php endif; ?>

        <form id="myForm" action="<?php echo e(route('save_purchase_order')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-body add-product pb-0">
                    <div class="accordion-card-one accordion" id="accordionExample">
                        <div class="accordion-item">
                            <div class="accordion-header" id="headingOne">
                                <div class="accordion-button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-controls="collapseOne">
                                    
                                </div>
                            </div>
                            <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Number</label>
                                                <input type="text" name="po_number" class="form-control" value="<?php echo e($newPOId); ?>" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">PO Date</label>
                                                <input type="date" name="po_date" value="<?php echo e(date('Y-m-d')); ?>" class="form-control" >
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Company</label>
                                                <select class="form-control" name="company" id="company_id" required="required">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>"><?php echo e($row->company_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        </div>
                                        <div class="row">
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Supplier</label>
                                                <select class="form-control" name="supplier" id="supplier_select" >
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" data-top="<?php echo e($row->top); ?>"><?php echo e($row->supplier_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                         <!-- <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Products</label>
                                                <select class="form-control" name="product_id" id="product_select" >
                                                    <option value="">Select</option>
                                                    
                                                </select>
                                            </div>
                                        </div> -->
                                        <div class="col-lg-4 col-sm-6 col-12">
                                            <div class="mb-3 add-product">
                                                <label class="form-label">Transporter</label>
                                                <select class="form-control" name="transporter" id="transporter_id">
                                                    <option value="">Select</option>
                                                    <?php $__currentLoopData = $transporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($row->id); ?>" ><?php echo e($row->transporter_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <h5>Order Items</h5>
                                            <div class="table-responsive">
                                                <table class="table table-bordered" id="order-items">
                                                    <thead>
                                                        <tr>
                                                            <th>Action</th>
                                                            <th>Product Name</th>
                                                            <th>Design/Varient No</th>
                                                            <th>No Of Rolls</th>
                                                            <th>Rate /Unit</th>
                                                            <th>Quantity /Roll</th>
                                                            <th style="width: 30%">UOM</th>
                                                            <th>% GST</th>.
                                                            <th style="width: 60%">Amount</th>
                                                            
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr class="order-row">
                                                           <td>
                                                            <a href="#" class="btn btn-danger remove-item" style="color:white;background:red"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>
                                                           </td>
                                                              
                                                            <td>
                                                                <select name="product_id[]" class="form-control product-select" id="product_select" required>
                                                                <option value="">Select Product</option>
                                                               <!--   -->
                                                                </select>
                                                            </td> 
                                                            
                                                            <td>
                                                                <select name="varient_id[]" class="form-control variant-select"  required>
                                                                <option value="">Select Varient</option>
                                                                
                                                                </select>
                                                            </td>
                                                            <td><input type="text" name="no_of_rolls[]" class="form-control no_of_rolls" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$"></td>
                                                            <td><input type="text" name="rate[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" class="form-control rate" required></td>
                                                            <td><input type="text" name="quantity[]" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$" class="form-control quantity" required></td>
                                                            <td>


                                                                <input type="hidden"  class="form-control hsn_code" >
                                                                 <input type="hidden"  class="form-control top" >
                                                                <select name="uom[]" class="form-control uom"  required>
                                                                    <option value="">Select Units</option>
                                                                    <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($row->id); ?>"><?php echo e($row->unit_name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                                                    </select>

                                                            </td>
                                                            <td><input type="text" name="gst_percent[]" class="form-control gst_percent" readonly onkeypress="return event.charCode >= 48 && event.charCode <= 57" ></td>
                                                            <td><input type="text" name="total[]" class="form-control total" readonly></td>

                                                        </tr>
                                                        <tr>
                                                        <td>
                                                                   
                                                                    
                                                            <a href="#" class="btn btn-success add-item" style="color:white;background:green"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-plus-circle plus">
                                                                <circle cx="12" cy="12" r="10"></circle>
                                                                <line x1="12" y1="8" x2="12" y2="16"></line>
                                                                <line x1="8" y1="12" x2="16" y2="12"></line>
                                                            </svg></a>
                                                        </td></tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <!-- Gross Total -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Gross Total:</label>
                                                <input type="number" name="subtotal" class="form-control grosstotal" readonly>
                                            </div>
                                        </div>
                                        
                                        <!-- Forwarding Percentage and Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">Forwarding:</label>
                                                <div class="input-group" style="width: 50%;">
                                                    <input type="text" class="form-control forwarding_percent"  name="f_percent" oninput="this.value = this.value.replace(/[^0-9.]/g, '')"
       pattern="^\d*\.?\d*$">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="text" name="f_amount" class="form-control ms-3 f_amount"  style="width: 50%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 offset-lg-8"  style="display:none" id="cgst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">CGST:</label>
                                                
                                                <input type="text" name="cgst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 offset-lg-8"  style="display:none" id="sgst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">SGST:</label>
                                                
                                                <input type="text" name="sgst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 offset-lg-8" style="display:none" id="igst_div">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">IGST:</label>
                                                
                                                <input type="text" name="igst_amount" class="form-control ms-3 "  style="width: 80%;" onkeypress="return event.charCode >= 48 && event.charCode <= 57" readonly>
                                            </div>
                                        </div>
                                        <input type="hidden" name="forwarding" class="form-control forwarding" readonly>
                                        <!-- <input type="hidden" name="gst_amount" class="form-control" readonly> -->
                                         <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center mb-3">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;">GST Amount:</label>
                                                <input type="number" id="gst_total_input" name="gst_amount_data" class="form-control " readonly>
                                            </div>
                                        </div>
                                        <!-- Final Amount -->
                                        <div class="col-lg-4 offset-lg-8">
                                            <div class="d-flex align-items-center">
                                                <label class="form-label me-2 mb-0" style="white-space: nowrap;margin-left:-12px">Final Amount:</label>
                                                <input type="number" name="grand_total" class="form-control" readonly>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    
                                    <hr>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="d-flex align-items-center mb-2">
                                                <label class="form-label me-2">Note:</label>
                                                <input type="text" name="note" class="form-control"  >
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

             <div class="mt-4">
                    <h5><strong>GST Summary</strong></h5><br>
                    <table class="table table-bordered" id="gst-summary-table">
                        <thead>
                            <tr>
                                <th>HSN Code</th>
                                <th>GST %</th>
                                <th>CGST %</th>
                                <th>SGST %</th>
                                <th>IGST %</th>
                                <th>Total GST Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                           
                        </tbody>
                    </table>
                </div> <br>

            <div class="col-lg-12">
                <div class="btn-addproduct mb-4">
                    <button type="button" class="btn btn-cancel me-2">Cancel</button>
                    <button type="submit" id="submitBtn" class="btn btn-primary">Save</button>
                </div>
            </div>
        </form>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>




<?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
$(document).ready(function () {


$('#supplier_select').on('change', function() {
        let supplierId = $(this).val();

        if (supplierId) {
            $.ajax({
                url: '/get-products-by-supplier/' + supplierId,
                type: 'GET',
                success: function(response) {
                    $('#product_select').empty().append('<option value="">Select Product</option>');
                    $.each(response.products, function(index, product) {
                        $('#product_select').append('<option value="' + product.id + '">' + product.product_name + '</option>');
                    });
                }
            });
        } else {
            $('#product_select').html('<option value="">Select</option>');
        }
    });
    


    document.getElementById("myForm").addEventListener("submit", function(event) {
        let submitBtn = document.getElementById("submitBtn");
        
        if (submitBtn.disabled) {
            event.preventDefault(); // Prevent form resubmission
            alert("Please wait, your info is submitted.");
        } else {
            submitBtn.disabled = true;
            submitBtn.innerText = "Submitting...";
        }
    });
    

    const productSelect = $('#product_select');

   // Initialize existing variant-select dropdowns as disabled
    $('.variant-select').prop('disabled', true);

    // Enable/Disable variant-select based on supplier selection
    $(document).on('change', '.product-select', function () {
        const row = $(this).closest('tr'); // Scope to the current row
        const product_id = $(this).val();
        const variantDropdown = row.find('.variant-select'); // Only the dropdown in this row

        if (product_id) {
            $.ajax({
                url: '/get-variants-by-product-po',
                method: 'GET',
                data: { product_id: product_id },
                success: function (response) {
                    variantDropdown.empty(); // Clear options
                    variantDropdown.append('<option value="">Select Variant</option>');

                    if (response.length > 0) {
                        response.forEach(variant => {
                            variantDropdown.append(
                                `<option value="${variant.id}">${variant.varient_code} - ${variant.varient_name}</option>`
                            );
                        });
                    } else {
                        alert('No variants found for this product.');
                    }
                },
                error: function () {
                    alert('Failed to fetch variants. Please try again.');
                }
            });
        }

        // Enable or disable the variant dropdown in the current row
        const isProductSelected = !!product_id;
        variantDropdown.prop('disabled', !isProductSelected);

        const selectedSupplier = $(this).find(':selected').data('top'); 
        toggleGstFields(selectedSupplier); // If still needed
    });

  // let firstRow = $('#order-items tbody tr:first');
  // firstRow.find('.add-item').replaceWith('<a href="#" class="btn btn-danger remove-item" style="color:white;background:red"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>');
    // Add Item Event
    $(document).on('click', '.add-item', function (e) {
        e.preventDefault();

        // Get the current row and update its button to 'Remove'
       // let currentRow = $(this).closest('tr');
      
        //currentRow.find('.add-item').replaceWith('<a href="#" class="btn btn-danger remove-item" style="color:white;background:red"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-minus-circle minus"><circle cx="12" cy="12" r="10"></circle><line x1="8" y1="12" x2="16" y2="12"></line></svg></a>');

        // Clone the first row for a new entry
         // Find the last filled row (any row with at least one non-empty input)
    let lastFilledRow = $('#order-items tbody tr').filter(function() {
        return $(this).find('input').filter(function() {
            return $(this).val().trim() !== ''; // Check if any input has value
        }).length > 0; // If there is at least one non-empty input, it's filled
    }).last(); // Get the last filled row

    let newRow = lastFilledRow.length ? lastFilledRow.clone() : $('#order-items tbody tr:first').clone();
    newRow.find('input').val(''); // Clear input fields
    newRow.find('.variant-select').prop('disabled', !productSelect.val());

    // Append the new row **after the last filled row**
    lastFilledRow.length ? lastFilledRow.after(newRow) : $('#order-items tbody').prepend(newRow);
       
    });

    // Remove Item Event
    $(document).on('click', '.remove-item', function (e) {
        e.preventDefault();
        if ($('.remove-item').length > 1) {
            $(this).closest('tr').remove();
            calculateForwarding();

            recalculateGstAmount();
            calculateTotal();
        }else {
            alert("You must keep at least one item in the list.");
        }
    });


    // Rate and Quantity Input Event
    $(document).on('input', '.no_of_rolls,.rate, .quantity', function () {
      

        let row = $(this).closest('tr');

        let no_of_rolls = parseFloat(row.find('.no_of_rolls').val()) || 0;
        let rate = parseFloat(row.find('.rate').val()) || 0;
        let quantity = parseFloat(row.find('.quantity').val()) || 0;
        let total = rate * quantity * no_of_rolls;
        row.find('.total').val(total.toFixed(2));

        let gst_percent = parseFloat(row.find('.gst_percent').val()) || 0;
        let net_total=total + (total * gst_percent/100 );
        row.find('.nettotal').val(net_total.toFixed(2));

       
                let halfGst = gst_percent / 2; 

                let totalformsp= total * halfGst/100;

                let totalforoms= total * gst_percent/100;


     // Add the totalformsp and totalforoms for each row
     let total_cgst = 0;
     let total_sgst = 0;
     let total_igst = 0;

    
        calculateTotal();

       
    });


    $('input[name="f_percent"]').on('input', calculateForwarding);


    function calculateForwarding() {

    let gst_percent_single = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;

    
    var forwarding_percent = parseFloat($('input[name="f_percent"]').val()) || 0; 
   
    var grosstotal = parseFloat($('input[name="subtotal"]').val()) || 0; 
    
    var f_amount = parseFloat($('input[name="f_amount"]').val()) || 0;
    
   
    var forwarding = grosstotal * forwarding_percent / 100;
    console.log(forwarding);
  
 
    $('input[name="f_amount"]').val(forwarding.toFixed(2)); 
     var famt=grosstotal+forwarding;
    let gstnewAmount = (famt* gst_percent_single) / 100;

    let halfGst_rownew = gst_percent_single / 2;
    let halfamount=gstnewAmount/2;
    $('input[name="gst_amount"]').val(gstnewAmount.toFixed(2));

     $('input[name="cgst_amount"]').val(halfamount.toFixed(2));
    $('input[name="sgst_amount"]').val(halfamount.toFixed(2));
    $('input[name="igst_amount"]').val(gstnewAmount.toFixed(2));


    calculateTotal();
   }
  
    function calculateTotal() {
        let subtotal = 0;
        $('#order-items tbody tr').each(function () {
            let total = parseFloat($(this).find('.total').val()) || 0;
            subtotal += total;
        });

        // Update subtotal
        $('input[name="subtotal"]').val(subtotal.toFixed(2));
       
        //new code forwarding & gst
        var fper=parseFloat($('input[name="f_percent"]').val()) || 0;
        var fsub=parseFloat($('input[name="subtotal"]').val())|| 0;
        var newforwarding = fsub * fper / 100;
        
       // let forwarding = parseFloat($('input[name="forwarding"]').val()) || 0;
       $('input[name="f_amount"]').val(newforwarding.toFixed(2));
        let gst_percent_new = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;
        let fnew=fsub+newforwarding
        let gstnewAmountdata = (fnew * gst_percent_new) / 100;
        let halfGst_new = gst_percent_new / 2;
        let halfamountnew=gstnewAmountdata/2;
       $('input[name="gst_amount"]').val(gstnewAmountdata.toFixed(2));
       $('input[name="cgst_amount"]').val(halfamountnew.toFixed(2));
       $('input[name="sgst_amount"]').val(halfamountnew.toFixed(2));
       $('input[name="igst_amount"]').val(gstnewAmountdata.toFixed(2));

       //end code

        let forwarding = parseFloat($('input[name="f_amount"]').val()) || 0;
        // let gst_amount = parseFloat($('input[name="gst_amount"]').val()) || 0;
         let gst_amount = parseFloat($('input[name="gst_amount_data"]').val()) || 0;
       
        let grandTotal = subtotal + forwarding + gst_amount;


        $('input[name="grand_total"]').val(grandTotal.toFixed(2));
    }



 

    $(document).on('change', '.variant-select', function () {
      var variantId = $(this).val(); 
      var row = $(this).closest('tr'); 

      if (variantId) {
        $.ajax({
            url: '<?php echo e(route("getVariantDetails")); ?>', 
            type: 'GET',
            data: { id: variantId },
            success: function (response) {
                console.log(response);
                // Update the fields in the same row
                row.find('.rate').val(response.rate);
                row.find('.quantity').val(response.quantity);
                row.find('.uom').val(response.uom_id);
                row.find('.gst_percent').val(response.gst_rate);
                 row.find('.hsn_code').val(response.hsn_code);
                  row.find('.top').val(response.top);
               
            },
            error: function (xhr) {
                console.error("Error fetching variant details: ", xhr.responseText);
            }
        });
     }
   });
   
   
   
   $(document).on('change', '.uom', function () {
    var unitId = $(this).val(); 
  
    var row = $(this).closest('tr'); 
    var rate = parseFloat(row.find('.rate').val()) || 0;
    var quantity = parseFloat(row.find('.quantity').val()) || 0;
    var no_of_rolls = parseFloat(row.find('.no_of_rolls').val()) || 1;
    let gst_percent_data = parseFloat($('#order-items tbody tr:first').find('.gst_percent').val()) || 0;
    
    // Store previous values in data attributes
    if (!row.data('originalRate')) {
        row.data('originalRate', rate);
        row.data('originalQuantity', quantity);
    }

    if (unitId) {
        $.ajax({
            url: '<?php echo e(route("convertunit")); ?>', 
            type: 'GET',
            data: { id: unitId, rate: rate, quantity: quantity, no_of_rolls: no_of_rolls },
            success: function (response) {
                console.log(response);

                if ( response.unit_name === 'sqft' ||
			    response.unit_name === 'Sqft' ||
			    response.unit_name === 'SQFT' ||
			    response.unit_name === 'sq.feet') {
                    // Restore previous values
                    row.find('.rate').val(row.data('originalRate').toFixed(2));
                    row.find('.quantity').val(row.data('originalQuantity'));
                    
                } else {
                    // Convert and update values
                    row.find('.rate').val(response.rate.toFixed(2));
                    row.find('.quantity').val(response.quantity);
                }

                row.find('.uom').val(response.uom_id);
                row.find('.no_of_rolls').val(response.no_of_roll);

                

                // Update total
                row.find('.total').val(parseFloat(row.find('.rate').val()) * parseFloat(row.find('.quantity').val()) * no_of_rolls);

                // Calculate gross total
                var grossTotal = 0;
                $('.total').each(function() {
                    grossTotal += parseFloat($(this).val()) || 0;
                });

                $('.grosstotal').val(grossTotal.toFixed(2));
                
                 var fper=parseFloat($('input[name="f_percent"]').val()) || 0;
                 var fsub=parseFloat($('input[name="subtotal"]').val()) || 0;
                  var newforwarding = fsub * fper / 100;
                 $('input[name="f_amount"]').val(newforwarding.toFixed(2));
               
                
                 let forwarding = parseFloat($('input[name="f_amount"]').val());
               //  let newamt=forwarding + grossTotal;
                   let newamt= grossTotal;
                

                let gstnewAmount = (newamt * gst_percent_data) / 100;
               
                let halfamountnew=gstnewAmount/2;
                $('input[name="gst_amount_data"]').val(gstnewAmount.toFixed(2));
                $('input[name="cgst_amount"]').val(halfamountnew.toFixed(2));
                $('input[name="sgst_amount"]').val(halfamountnew.toFixed(2));
                $('input[name="igst_amount"]').val(gstnewAmount.toFixed(2));
                
                console.log("Gross Total: ", grossTotal.toFixed(2));
                var finaltotal=gstnewAmount + grossTotal + forwarding;
              
                $('input[name="grand_total"]').val(finaltotal.toFixed(2));
                
                   updateGstSummary();
            },
            error: function (xhr) {
                console.error("Error fetching unit details: ", xhr.responseText);
            }
        });
    }
});


      

        function toggleGstFields(supplierTop) {
        const cgstField = $('#cgst_div');
        const sgstField = $('#sgst_div');
        const igstField = $('#igst_div');

        if (supplierTop === 'OMS') {
            cgstField.hide();
            sgstField.hide();
            igstField.show();
        } else if (supplierTop === 'MSP') {
            cgstField.show();
            sgstField.show();
            igstField.hide();
        }
    }




    function getLatestSubtotal() {
    return parseFloat($('.grosstotal').val()) || 0; 

}

  $('#company_id').select2({
        placeholder: "Select Company",   
        allowClear: true,
		search:true,
		          
    });
    
      $('#supplier_select').select2({
        placeholder: "Select Supplier",   
        allowClear: true,
		search:true,
		          
    });
    
      $('#transporter_id').select2({
        placeholder: "Select Transporter",   
        allowClear: true,
		search:true,
		          
    });
    
    
  
        
});

</script>


<!-- gst summary -->

<script>
  $(document).ready(function () {
    let f_amount = 0;
    $('.forwarding_percent').on('input', function () {
        const percent = parseFloat($(this).val()) || 0;
        const subtotal = parseFloat($('.grosstotal').val()) || 0;

        f_amount = (subtotal * percent) / 100;
         //console.log(f_amount);
        $('.f_amount').val(f_amount.toFixed(2)); // Set value in input
        updateGstSummary();
    });
});


function updateGstSummary() {
    let gstGroups = {};
    const forwd = parseFloat($('.f_amount').val()) || 0;
    // Loop through each row in the product table
    document.querySelectorAll('#order-items tbody tr').forEach(row => {
        let qty = parseFloat(row.querySelector('.quantity')?.value || 0);
        let rate = parseFloat(row.querySelector('.rate')?.value || 0);
         let no_of_rolls = parseFloat(row.querySelector('.no_of_rolls')?.value || 0);
        let gst = parseFloat(row.querySelector('.gst_percent')?.value || 0);
        let hsncode = row.querySelector('.hsn_code')?.value || 'N/A';
        let top = row.querySelector('.top')?.value || 'N/A';
           
        // console.log("Forwarding Value:", forwd); // debugging
        // let amount = no_of_rolls * qty * rate;
        //  let fttl = parseFloat(forwd || 0) + parseFloat(amount || 0);
        // let gstAmount = (fttl * gst) / 100;

          let amount = no_of_rolls * qty * rate;
          let gstAmount = (amount * gst) / 100;

         

        if (!gstGroups[hsncode]) {
            gstGroups[hsncode] = {};
        }

        if (!gstGroups[hsncode][gst]) {
            gstGroups[hsncode][gst] = {
                cgst: 0,
                sgst: 0,
                igst: 0,
                total: 0
            };
        }

        if (top === 'OMS') {
            gstGroups[hsncode][gst].igst += gstAmount;
        } else {
            gstGroups[hsncode][gst].cgst += gstAmount / 2;
            gstGroups[hsncode][gst].sgst += gstAmount / 2;
        }

        gstGroups[hsncode][gst].total += gstAmount;
    });

    // Clear GST table
    const gstTableBody = document.querySelector('#gst-summary-table tbody');
    gstTableBody.innerHTML = '';
    let totalGstSum = 0;
    // Populate new values
    for (let hsn in gstGroups) {
        for (let gst in gstGroups[hsn]) {
            let data = gstGroups[hsn][gst];
             totalGstSum += data.total;
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${hsn}</td>
                <td>${gst}%</td>
                <td>₹ ${data.cgst.toFixed(2)}</td>
                <td>₹ ${data.sgst.toFixed(2)}</td>
                <td>₹ ${data.igst.toFixed(2)}</td>
                <td>₹ ${data.total.toFixed(2)}</td>
            `;
            gstTableBody.appendChild(row);
        }
    }
     document.getElementById('gst_total_input').value = totalGstSum.toFixed(2);
}

// Trigger calculation on page load and when items change

function bindGstEvents() {
    updateGstSummary();

    document.querySelectorAll('#order-items').forEach(table => {
        table.addEventListener('input', function () {
            updateGstSummary();
        });
    });
}

document.addEventListener('DOMContentLoaded', bindGstEvents);
</script>


<?php /**PATH /var/www/fflive/ff-live/fflive/resources/views/admin/add_purchase.blade.php ENDPATH**/ ?>